/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.custom_blocks;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import com.moulberry.axiom.custom_blocks.CustomBlock;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.custom_blocks.CustomBlockStateImplementation;
import com.moulberry.axiom.custom_blocks.update.CustomBlockUpdater;
import com.moulberry.axiom.utils.IntWrapper;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class CustomBlockImplementation
implements CustomBlock {
    private final class_2960 resourceLocation;
    private final String translationKey;
    private final class_1799 pickBlockStack;
    private final boolean doNormalInteractions;
    private final CustomBlockState defaultBlockState;
    private final class_2689<CustomBlock, CustomBlockStateImplementation> stateDefinition;
    private final List<CustomBlockUpdater> updaters;

    public CustomBlockImplementation(class_2960 resourceLocation, String translationKey, class_1799 pickBlockStack, boolean doNormalInteractions, List<class_2769<?>> properties, List<CustomBlockUpdater> updaters, List<class_2680> vanillaStates) {
        IntWrapper index = new IntWrapper();
        class_2689.class_2690 builder = new class_2689.class_2690((Object)this);
        properties.forEach(xva$0 -> builder.method_11667(new class_2769[]{xva$0}));
        class_2689 stateDefinition = builder.method_11668(customBlock -> (CustomBlockStateImplementation)customBlock.defaultCustomState(), (block, immutableMap, mapCodec) -> {
            if (index.value >= vanillaStates.size()) {
                throw new RuntimeException(String.valueOf(resourceLocation) + " - faulty definition: not enough vanilla states");
            }
            class_2680 vanillaState = (class_2680)vanillaStates.get(index.value);
            ++index.value;
            return new CustomBlockStateImplementation((CustomBlock)block, vanillaState, (ImmutableMap<class_2769<?>, Comparable<?>>)immutableMap, (MapCodec<CustomBlockStateImplementation>)mapCodec);
        });
        if (index.value < vanillaStates.size()) {
            throw new RuntimeException(String.valueOf(resourceLocation) + " - faulty definition: too many vanilla states");
        }
        this.resourceLocation = resourceLocation;
        this.translationKey = translationKey;
        this.pickBlockStack = pickBlockStack;
        this.doNormalInteractions = doNormalInteractions;
        this.stateDefinition = stateDefinition;
        this.defaultBlockState = (CustomBlockState)stateDefinition.method_11664();
        this.updaters = updaters;
        for (CustomBlockUpdater updater : updaters) {
            if (updater.hasRequiredProperties(this.stateDefinition.method_11659())) continue;
            throw new RuntimeException(String.valueOf(resourceLocation) + " - state definition doesn't contain required property for " + String.valueOf(updater.getClass()));
        }
    }

    @Override
    public class_2960 getResourceLocation() {
        return this.resourceLocation;
    }

    @Override
    public String translationKey() {
        return this.translationKey;
    }

    @Override
    public class_1799 customPickBlockStack() {
        return this.pickBlockStack.method_7972();
    }

    @Override
    public boolean doNormalInteractions() {
        return this.doNormalInteractions;
    }

    public class_2689<CustomBlock, CustomBlockStateImplementation> getStateDefinition() {
        return this.stateDefinition;
    }

    @Override
    public Collection<class_2769<?>> getProperties() {
        return this.stateDefinition.method_11659();
    }

    @Override
    public List<CustomBlockState> getPossibleCustomStates() {
        return this.stateDefinition.method_11662();
    }

    @Override
    public CustomBlockState defaultCustomState() {
        return this.defaultBlockState;
    }

    @Override
    public CustomBlockState customShapeUpdate(CustomBlockState blockState, class_1936 levelAccessor, class_2338 blockPos) {
        CustomBlockUpdater updater;
        Iterator<CustomBlockUpdater> iterator = this.updaters.iterator();
        while (iterator.hasNext() && (blockState = (updater = iterator.next()).customShapeUpdate(blockState, levelAccessor, blockPos)) != null) {
        }
        return blockState;
    }

    @Override
    @Nullable
    public CustomBlockState getCustomStateForPlacement(class_1750 blockPlaceContext) {
        CustomBlockUpdater updater;
        CustomBlockState blockState = this.defaultBlockState;
        Iterator<CustomBlockUpdater> iterator = this.updaters.iterator();
        while (iterator.hasNext() && (blockState = (updater = iterator.next()).getStateForPlacement(blockState, blockPlaceContext)) != null) {
        }
        return blockState;
    }
}

